<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:strip-space elements="*"/>
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <!-- Variables to hold unit strings -->
    <xsl:variable name="linearUnit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">ft</xsl:when>
            <xsl:otherwise>m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit1">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">sq ft</xsl:when>
            <xsl:otherwise>sq m</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="areaUnit2">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'">ac</xsl:when>
            <xsl:otherwise>ha</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Variables to hold Direction Method, Format, Precision and Mode -->
    <xsl:variable name="mapCheckAngularMethod">
        <xsl:choose>
            <xsl:when test="//@angularUnits = 'Grads'">2</xsl:when>
            <xsl:when test="//@angularUnits = 'Radians'">3</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mapCheckAngularFormat">
        <xsl:choose>
            <xsl:when test="//@directionFormat = 'Decimal Degrees'">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mapCheckDirectionFormat">
        <xsl:choose>
            <xsl:when test="//@directionFormat = 'Decimal Degrees'">2</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="mapCheckDirectionModeFormat">
        <xsl:choose>
            <xsl:when test="//@directionMode = 'North Bearing'">2</xsl:when>
            <xsl:when test="//@directionMode = 'North Azimuth'">3</xsl:when>
            <xsl:when test="//@directionMode = 'South Azimuth'">4</xsl:when>
            <xsl:otherwise>1</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Map Check ASCII Report -->
    <xsl:output method="text" media-type="text/plain" encoding="iso-8859-1"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <xsl:choose>
            <xsl:when test="$xslShowHelp = 'true'">
                <xsl:call-template name="StyleSheetHelp"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="InRoads">
                    <xsl:text/>
                    <!-- Report Title -->
                    <xsl:text>Výpis Map kontroly&#xd;&#xd;</xsl:text>
                    <!-- Project Data -->
                    <xsl:for-each select="GeometryProject">
                        <xsl:text>Projekt:     </xsl:text><xsl:value-of select="@name"/>
                        <!-- Horizontal Alignment Data -->
                        <xsl:for-each select="HorizontalAlignment">
                            <xsl:text>&#xd;Trasa:   </xsl:text><xsl:value-of select="@name"/>
                            <xsl:text>&#xd;Popis: </xsl:text><xsl:value-of select="@description"/>
                            <xsl:text>&#xd;&#xd;</xsl:text>
                            <xsl:text> Typ       Název bodu\                           Y\              X\&#xd;</xsl:text>
                            <xsl:text>             Směr           Délka    Šířka    Odklon&#xd;</xsl:text>
                            <xsl:text>-----  ---------------  ------------------  --------------  --------------&#xd;</xsl:text>
                            <xsl:apply-templates select="//HorizontalLine | //HorizontalCircle"/>
                            <xsl:if test="@northingClosingError">
                                <xsl:text>Y chyba:    </xsl:text>
                                <xsl:value-of select="cif:distanceFormat(number(@northingClosingError))"/>
                                <xsl:text> </xsl:text><xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd;X chyba:     </xsl:text>
                                <xsl:value-of select="cif:distanceFormat(number(@eastingClosingError))"/>
                                <xsl:text> </xsl:text><xsl:value-of select="$linearUnit"/>
                                <xsl:text>&#xd;Směr uzavření: </xsl:text>
                                <xsl:value-of select="cif:directionFormat(number(@closingDirection))"/>
                                <xsl:text>&#xd;Délka uzavření:  </xsl:text>
                                <xsl:value-of select="cif:distanceFormat(number(@closingDistance))"/>
                                <xsl:text> </xsl:text><xsl:value-of select="$linearUnit"/>
                                <xsl:if test="@area">
                                    <xsl:text>&#xd;Plocha uzavření:       </xsl:text>
                                    <xsl:value-of select="cif:areaFormat(number(@area))"/>
                                    <xsl:text> </xsl:text><xsl:value-of select="$areaUnit1"/>
                                    <xsl:text> (</xsl:text>
                                    <xsl:choose>
                                        <xsl:when test="//@linearUnits = 'Imperial'">
                                            <td align="right">
                                                <xsl:value-of select="cif:areaFormat(number(@area div 43560))"/>
                                            </td>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <td align="right">
                                                <xsl:value-of select="cif:areaFormat(number(@area div 10000))"/>
                                            </td>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:text> </xsl:text><xsl:value-of select="$areaUnit2"/><xsl:text>)</xsl:text>
                                    <xsl:text>&#xd;Obvod:         </xsl:text>
                                    <xsl:value-of select="cif:distanceFormat(number(@perimeter))"/>
                                    <xsl:text> </xsl:text><xsl:value-of select="$linearUnit"/>
                                </xsl:if>
                                <xsl:text>&#xd;Přesnost:         </xsl:text>
                                <xsl:value-of select="cif:distanceFormat(number(@closingPrecision))"/>
                                <xsl:text>&#xd;</xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Horizontal Line Data -->
    <xsl:template match="HorizontalLine">
        <xsl:value-of select="cif:columnFormat(string(Start/@type), 6)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 8)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('    ', '    ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 41)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 16)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@direction))), 21)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 20)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing - Start/@northing), 16)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting - Start/@easting), 16)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(string(End/@type), 6)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 8)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('    ', '    ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 41)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 16)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>
    <!-- Horizontal Circle Data -->
    <xsl:template match="HorizontalCircle">
        <xsl:value-of select="cif:columnFormat(string(Start/@type), 6)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Start/@name">
                <xsl:value-of select="cif:columnFormat(string(Start/@name), 8)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('    ', '    ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@northing), 41)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Start/@easting), 16)"/>
        <xsl:text>&#xd;       Poloměr:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@radius), 28)"/>
        <xsl:text>&#xd;       Delta:</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:angularFormat(number(@delta))), 30)"/>
        <xsl:text>&#xd;       Délka:</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(@length), 28)"/>
        <xsl:if test="@tangentLength != -1.">
            <xsl:text>&#xd;       Tětiva:</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(@chord), 29)"/>
            <xsl:text>&#xd;       Tečna:</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(@tangentLength), 27)"/>
            <xsl:text>&#xd;       Střední pořadnice:</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(@middleOrdinate), 19)"/>
            <xsl:text>&#xd;       Externí:</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(@externalDistance), 26)"/>
            <xsl:text>&#xd;</xsl:text>
            <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionStart))), 21)"/>
            <xsl:text> (Radiální)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(Center/@northing - Start/@northing), 28)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(Center/@easting - Start/@easting), 16)"/>
        </xsl:if>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(Center/@type), 6)"/>
        <xsl:text> (</xsl:text>
        <xsl:choose>
            <xsl:when test="Center/@name">
                <xsl:value-of select="cif:columnFormat(string(Center/@name), 8)"/>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="concat('    ', '    ')"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@northing), 41)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(Center/@easting), 16)"/>
        <xsl:text>&#xd;       </xsl:text>
        <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
        <xsl:text> (Tětiva)</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        <xsl:value-of select="cif:columnFormat(string(cif:directionFormat(number(@radialDirectionEnd))), 21)"/>
        <xsl:text> (Radiální)</xsl:text>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing - Center/@northing), 28)"/>
        <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting - Center/@easting), 16)"/>
        <xsl:text>&#xd;</xsl:text>
        <xsl:if test="position() = last()">
            <xsl:value-of select="cif:columnFormat(string(End/@type), 6)"/>
            <xsl:text> (</xsl:text>
            <xsl:choose>
                <xsl:when test="End/@name">
                    <xsl:value-of select="cif:columnFormat(string(End/@name), 8)"/>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat('    ', '    ')"/></xsl:otherwise>
            </xsl:choose>
            <xsl:text>)</xsl:text>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@northing), 41)"/>
            <xsl:value-of select="cif:columnDoubleFormat(number(End/@easting), 16)"/>
            <xsl:text>&#xd;&#xd;</xsl:text>
        </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <xsl:text>Poznámky&#xd;&#xd;</xsl:text>
        <xsl:text>    Tento výpis lze použít pro data z Geometrie &gt;&#xd;</xsl:text>
        <xsl:text>    Utility &gt; Upravit polygon. pořad nebo Nástroje &gt;&#xd;</xsl:text>
        <xsl:text>    XML Výpisy &gt; Kontrolovat.&#xd;&#xd;</xsl:text>
        <xsl:text>    Pro výpis v Kontrolovat musíte vybrat&#xd;</xsl:text>
        <xsl:text>    nejméně jedno směrové řešení v&#xd;</xsl:text>
        <xsl:text>    poli Zahrnout v Nástroje &gt; XML Výpisy &gt; Kontrolovat.&#xd;</xsl:text>
        <xsl:text>    Poznámka:  Většina délkových a směrových hodnot&#xd;</xsl:text>
        <xsl:text>    v těle tohoto výpisu nepoužívá nastavení v&#xd;</xsl:text>
        <xsl:text>    Nástroje &gt; Možnosti formátu v menu Průzkumník výpisů.&#xd;</xsl:text>
        <xsl:text>    Pouze hodnoty X/Y a hodnoty v zápatí používají &#xd;</xsl:text>
        <xsl:text>    toto nastavení.  Pokud použijete příkaz &#xd;</xsl:text>
        <xsl:text>    Upravit polygon. pořad, nastavení přesnosti&#xd;</xsl:text>
        <xsl:text>    hodnot délek a směru v těle výpisu&#xd;</xsl:text>
        <xsl:text>    pochází z Nástroje &gt; Možnosti, stejně jako směr a režim.&#xd;</xsl:text>
        <xsl:text>    Pro příkaz Kontrolovat&#xd;lze nastavit přesnost pro délky a směr&#xd;</xsl:text>
        <xsl:text>    v těle výpisu v&#xd; Nástroje&gt; XML Výpisy &gt; Kontrolovat a formát&#xd;</xsl:text>
        <xsl:text>    směru a režim opět v Nástroje &gt;&#xd;Možnosti.&#xd;&#xd;</xsl:text>
        <xsl:text>    Poznámka:  Tento výpis není vhodný pro geometrické trasy&#xd;</xsl:text>
        <xsl:text>    obsahující přechodnice.&#xd;&#xd;</xsl:text>
        <xsl:text>    Poznámka Civil Nástroje:&#xd;&#xd;</xsl:text>
        <xsl:text>    Nastavení přesnosti pro délky a směry v těle výpisu pochází z &#xd;</xsl:text>
        <xsl:text>    Nastavení Výkres.&#xd;&#xd;</xsl:text>
        <xsl:text>Copyright 2007 Bentley Systems, Inc&#xd;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
